﻿var lookupTablesTranslationEditor = {
    context: $("#LookupTableTranslationEditor"),
    questionnaireId: 0,
    bindGeneralEvents: function () {
        $(".v-translateLanguage, .v-referenceLanguage, .v-lookupTableSelector", lookupTablesTranslationEditor.context).each(function () {
            $(this).data("prev", $(this).val());
        });

        $(".v-translateLanguage, .v-referenceLanguage, .v-lookupTableSelector", lookupTablesTranslationEditor.context).on("change", function () {
            var select = $(this);
            var currentValue = select.val();
            var previousValue = select.data("prev");

            if (HasUnsavedChanges()) {
                modalDialog.showUnsavedChangesDialog(function () {
                    select.val(previousValue);
                    $.when(lookupTablesTranslationEditor.saveLookupTableTexts())
                     .then(function () {
                         select.val(currentValue);
                         select.data("prev", currentValue);
                         lookupTablesTranslationEditor.updateLookupTableEditor();
                     });
                }, function () {
                    select.data("prev", currentValue);
                    lookupTablesTranslationEditor.updateLookupTableEditor();
                }, function () {
                    select.val(previousValue);
                });
            } else {
                select.data("prev", currentValue);
                lookupTablesTranslationEditor.updateLookupTableEditor();
            }
        });

        $(".v-saveLookupTable").on("click", function () {
            $.when(lookupTablesTranslationEditor.saveLookupTableTexts())
             .then(function () { lookupTablesTranslationEditor.updateLookupTableEditor(); });
        });

        $(".v-cancel").on("click", function () {
            location.reload();
        });

        $(".v-print").on("click", function () {
            window.print();
        })
    },
    bindLookupTableEvents: function () {
        $(".v-translationTextBox", lookupTablesTranslationEditor.context).on("change", function () {
            $(this).attr("data-changed", "true");
        });
    },
    updateLookupTableEditor: function () {
        var $translationEdition = $(".v-translatorContainer", lookupTablesTranslationEditor.context);
        var translateLanguage = $(".v-translateLanguage").val();
        var referenceLanguage = $(".v-referenceLanguage").val();
        var lookupTableId = $(".v-lookupTableSelector").val();

        args = {
            referenceLanguageCode: referenceLanguage,
            translateLanguageCode: translateLanguage,
            lookupTableId: lookupTableId
        }

        a4.callServerMethod(a4.getAction("GetLookupTableTranslationEditor", "Surveys", "Settings"), args,
            function (result) {
                $translationEdition[0].innerHTML = result;                
                lookupTablesTranslationEditor.bindLookupTableEvents();
                a4ImageSelector.bindElements(lookupTablesTranslationEditor.context);
            }, null, { blockElement: $("#translate"), blockElementTimeout: 0, dataType: "html" }
        );
    },
    saveLookupTableTexts: function () {
        var columnTexts = {};

        $(".v-translationTextBox[data-changed='true']", lookupTablesTranslationEditor.context).map(function () { return TextObject(columnTexts, $(this)); });

        var toLanguage = $(".v-translateLanguage", lookupTablesTranslationEditor.context).val();
        var lookupTableId = $(".v-lookupTableSelector").val();

        var args = {
            tableId: lookupTableId,
            columnTexts: $.isEmptyObject(columnTexts) ? null : columnTexts,
            toLanguage: toLanguage
        };

        return a4.callServerMethod(a4.getAction("UpdateLookupTableColumnTexts", "Surveys", "Settings"), args,
            function (result) {
                a4.showSuccessMessage(resources.SuccessMessage, 2000);
            }, null, { blockElement: $("#translate") }
        );
    }
}

function TextObject(texts, $textBox) {
    var key = $textBox.attr("data-key");
    var value = "";

    value = $textBox.val().trim();

    texts[key] = value;
}

function HasUnsavedChanges() {
    return $(".v-translationTextBox[data-changed='true']", lookupTablesTranslationEditor.context).length > 0;
}

$(document).ready(function () {
    if (lookupTablesTranslationEditor.context.length > 0) {
        lookupTablesTranslationEditor.bindGeneralEvents();
        lookupTablesTranslationEditor.bindLookupTableEvents();
    }
});